% ham2mat converts the potential file that ham outputs to matlab's own
% data format.
% 
% HG 2012-01-13

inputham

Lx=xmax-xmin;
Ly=ymax-ymin;
Lz=zmax-zmin;
dV=Lx*Ly*Lz/((Nx-1)*(Ny-1)*(Nz-1));
 
dd=dir;
for ii=1:length(dd)
  if length(dd(ii).name)>11
    if strcmp(dd(ii).name(end-7:end),'.ham.dat')
      switch dd(ii).name(1:4)
       case 'phi_'
        phi = load(dd(ii).name);
        phi = reshape(phi,Ny,Nx,Nz);
        eval(['save -v7 ' dd(ii).name(1:end-7) 'ham.mat phi'])
        system(['rm ' dd(ii).name]);
         
       case 'Efi_'
        E = load(dd(ii).name);
        Elength=length(E);
        Ex = E(1:Elength/3);
        Ey = E(Elength/3+1:2*Elength/3);
        Ez = E(2*Elength/3+1:Elength); 
        Ex = reshape(Ex,Ny,Nx,Nz);
        Ey = reshape(Ey,Ny,Nx,Nz);
        Ez = reshape(Ez,Ny,Nx,Nz);
        eval(['save -v7 ' dd(ii).name(1:end-7) 'ham.mat Ex Ey Ez'])
        system(['rm ' dd(ii).name]);
       
       otherwise
        disp(['Nothing to do for file ' dd(ii).name])

      end % end switch dd(ii).name(1:4)
    end % end if strcmp(dd(ii).name(end-11:end),'.mustard.dat'
  end % end if length(dd(ii).name)>11
end % end for ii=1:length(dd)
 
 
